﻿//////////////////////////////////////////////
// ResourceSaveLoadCallback.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Node ;
}

/// Includes ---------------------------------

// nkGraphics
#include "Resource.h"

/// Internals --------------------------------

namespace nkGraphics
{
	// The node needs a wrapper to be able to be returned as a resource
	class ResourceNodeWrapper : public Resource
	{
		public :

			// Constructor, destructor
			ResourceNodeWrapper (System* system) noexcept ;

			// Getters
			Node* getNode () const ;

			// Setters
			void setNode (Node* value) ;

			// Overloads
			virtual bool load () override ;
			virtual void unload () override ;

		private :

			// Attributes
			Node* _node ;
	} ;
}

/// Class ------------------------------------

namespace nkGraphics
{
	// Le callback final
	class ResourceSaveLoadCallback
	{
		public :
	
			// Constructor
			ResourceSaveLoadCallback () noexcept ;

			// Getters
			bool getLoading () const ;

			// Setters
			void setLoading (bool value) ;			

			// Implementation
			virtual void onResourceCountUpdated (unsigned int value) = 0 ;
			virtual void onResourceSuccess (Resource* resource) = 0 ;
			virtual void onResourceFail (nkMemory::StringView path) = 0 ;

		private :
			
			// Attributes
			bool _loading ;
	} ;
}